<%@ Page Language="C#" AutoEventWireup="true" CodeFile="ReferralContact.aspx.cs" Inherits="ReferralContact" MasterPageFile = "~/Registry.master" %>
<%@ Register src="~/controls/FromToDate.ascx" tagname="FromToDate" tagprefix="UserControlFromToDate" %>

<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <link type = "text/css" href = "styles/StyleSheet.css" />

    <script src="scripts/date.js" type="text/javascript"></script>
    
    <style type="text/css">
            .style1
            {
                width: 100%;
            }
            .style2
            {
                width: 110px;
            }
            .style3
            {
            }
            .style4
            {
                width: 8px;
            }
            .style6
            {
                width: 110px;
            }
            .style8
            {
                width: 200px;
            }
            .style9
            {
                width: 100px;
            }
            .style10
            {
                width: 110px;
            }
            .style11
            {
                width: 250px;
            }
            .style12
            {
                width: 250px;
            }
            .style13
            {
                width: 200px;
            }
            .style14
            {
                width: 120px;
            } 
        </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <script src="scripts/jquery.meio.mask.js" type="text/javascript"></script>
    <script type = "text/javascript">
        function HideShowDates() {
            //alert("$('#<%= rbInpatientEval.ClientID %> input:checked').val()= " +
                //$('#<%= rbInpatientEval.ClientID %> input:checked').val());
            if ($('#<%= rbInpatientEval.ClientID %> input:checked').val() == 0)
            {
                $('tr.evalClass').hide();
                
            }
            else
            {
                $('tr.evalClass').show();
                
            }

            if ($('#<%= rbFollowup.ClientID %> input:checked').val() == 0)
            {

                ValidatorEnable($('[id*=FollowUpContactDateRequiredValidator]')[0], false);
//                var validator = $('[id*=FollowUpContactDateRequiredValidator]')[0];
//                validator.isvalid = true;
                $('tr.followupClass').hide();
                                            
            }
            else
            {
                ValidatorEnable($('[id*=FollowUpContactDateRequiredValidator]')[0], true);
                var validator = $('[id*=FollowUpContactDateRequiredValidator]')[0];
                validator.isvalid = true;
                ValidatorUpdateDisplay(validator);
                $('tr.followupClass').show();
                
            }
        }

        $(window).load(function() {
            
        });

        $(document).ready(function()
        {
            var rbInpatientEvalChecked = ($('#<%= rbInpatientEval.ClientID %> input:checked').val() == 0);
            $('#<%= InpatientEvalDate.Date.ClientID %>').attr('disabled', rbInpatientEvalChecked);

            HideShowDates();

            $('#<%=rbInpatientEval.ClientID %>').click(function()
            {
                //HideShowDates();

                if ($('#<%= rbInpatientEval.ClientID %> input:checked').val() == 0)
                {
                    $('tr.evalClass').hide();
                }
                else
                {
                    $('tr.evalClass').show();
                }
            });

            $('#<%=rbFollowup.ClientID %>').click(function()
            {
                //HideShowDates();
                if ($('#<%= rbFollowup.ClientID %> input:checked').val() == 0)
                {
                    ValidatorEnable($('[id*=FollowUpContactDateRequiredValidator]')[0], false);
                    //                    var validator = $('[id*=FollowUpContactDateRequiredValidator]')[0];
                    //                    validator.isvalid = true;

                    $('tr.followupClass').hide();

                    $('tr.followupClass input:text').val('');

                }
                else
                {

                    ValidatorEnable($('[id*=FollowUpContactDateRequiredValidator]')[0], true);
                    var validator = $('[id*=FollowUpContactDateRequiredValidator]')[0];
                    validator.isvalid = true;
                    ValidatorUpdateDisplay(validator);
                    $('tr.followupClass').show();
                }

            });

            $.mask.masks = $.extend($.mask.masks, { mskZip: { mask: '99999', autoTab: false },
                mskZipPlusFour: { mask: '9999', autoTab: false }
            });
            $('#<%= txtContactZip.ClientID %>').setMask('mskZip');
            $('#<%= txtContactPlus4.ClientID %>').setMask('mskZipPlusFour');
            $('#<%= rbInpatientEval.ClientID %>').click(function()
            {
                if ($('#<%= rbInpatientEval.ClientID %> input:checked').val() == 1)
                {
                    $('#<%= InpatientEvalDate.Date.ClientID %>').removeAttr('disabled');
                    $('#<%= InpatientEvalDate.Date.ClientID %>').focus();

                }
                else
                {
                    $('#<%= InpatientEvalDate.Date.ClientID %>').val('');
                    $('#<%= InpatientEvalDate.Date.ClientID %>').attr('disabled', 'disabled');

                }
            });

            $('input[id *= FollowupRequiredDate]').blur(function()
            {

                var fwupDate = Date.parseExact($(this).val(), "M/d/yyyy");

                if (fwupDate != null)
                {


                    if (Date.compare(fwupDate, Date.today()) > 0)
                    {
                        if (Date.compare(fwupDate.add(-3).days(), Date.today()) >= 0)
                        {
                            //$('input[id *= RemindDate]').val(Date.parseExact(d.add(-14).days(), "M/d/yyyy"));
                            var remDate = fwupDate;
                        }
                        else
                        {
                            //$('input[id *= RemindDate]').val(Date.parseExact(Date.today().add(1).days(), "M/d/yyyy"));
                            var remDate = Date.today().add(1).days();
                        }

                        $('input[id *= ReminderDate]').val(remDate.toString('M/d/yyyy'));
                    }
                }
                else
                {
                    $('input[id *= ReminderDate]').val('');

                }

                //$('input[id *= ReminderDate]').focus();

            });
        });
    </script> 
    <asp:ObjectDataSource ID="ObjectDataSourcePatient" runat="server" 
            SelectMethod="GetPatientByReferralId" 
            TypeName="VeteransAffairs.Registries.BusinessManager.ReferralManager">
            <SelectParameters>
                <asp:QueryStringParameter QueryStringField = "referralId" Direction = "Input" Name = "id" /> 
            </SelectParameters>       
     </asp:ObjectDataSource>
    <asp:ValidationSummary ID="ValidationSummaryReferralContact" runat="server" 
        TabIndex="1" 
        HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ValidationGroup="ReferralContactSave"
        ShowMessageBox="True" />
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server" Text= "My Tasks > Contact Logs > All Contacts > Referral # "  />
    </div>   
    <table>
        <tr>
            <td>
                <asp:FormView ID="FormViewPatientInformation" runat="server"  
                    DataSourceID="ObjectDataSourcePatient" Width="109%" 
                    DataKeyNames = "PATIENT_ID" Visible = "true">
                    <FooterStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" />
                    <RowStyle BackColor="#F7F6F3" ForeColor="#333333" />
                    <ItemTemplate>
                        <asp:Panel ID="PanelPatient" runat="server" 
                            GroupingText="Patient" 
                            Width="810px">
                            <table cellpadding="-1" cellspacing="-1" width="100%">
                                <tr style = "height:20px;" >
                                    <td style="width:20px;">
                                    </td>
                                    <td>
                                        <asp:Label SkinID="DataLabel" ID="LabelICN" runat="server" Text="ICN:" AssociatedControlID="VPIDLabel"></asp:Label>
                                        <asp:Label SkinID="DataLabel" ID="VPIDLabel" runat="server"  Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PATIENT_ICN")), false) %>' />
                                    </td>
                                    <td>
                                        <asp:Label SkinID="DataLabel" ID="LabelName" runat="server" Text="Name:" AssociatedControlID="NameLabel"></asp:Label>
                                        <asp:Label SkinID="DataLabel" ID="NameLabel" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("LAST_NAME")),false) + "," + "&nbsp;" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("FIRST_NAME")), false) + "&nbsp;" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("MIDDLE_NAME")), false)%>' />
                                    </td>
                                    <td >
                                        <asp:Label SkinID="DataLabel" ID="LabelForSSN" runat="server" Text="SSN:" AssociatedControlID="LabelSSN"></asp:Label>
                                        <asp:Label SkinID="DataLabel" ID = "LabelSSN" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("Snum")), false) %>'  />
                                    </td>
                                    <td>
                                        &nbsp;
                                    </td>
                                    <td>
                                        <asp:Label SkinID="DataLabel" ID="LabelForDOB" runat="server" Text="DOB:" AssociatedControlID="LabelDOB"></asp:Label>
                                        <asp:Label SkinID="DataLabel" ID = "LabelDOB" runat = "server"  Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("BIRTH_DATE", "{0:d}")), false) %>'/> 
                                    </td>
                                </tr>
                            </table>
                    </asp:Panel>   
                </ItemTemplate>
                </asp:FormView>
            </td> 
        </tr>
        <tr>
            <td>
            <asp:Panel ID="PanelContactDetails" runat="server" GroupingText="&nbsp;&nbsp;Contact Log Details&nbsp;&nbsp;" Width="100%">
                <table align= "left" class="style1" cellpadding = "5" cellspacing = "5" border="0">
                    <tr style = "height:18px;">
                        <td class="style3">
                            <asp:Label SkinID="DataLabel" ID="LabelContactFirstName" runat="server" 
                                Text="Person Contacted First Name * :" 
                                AssociatedControlID="TxtContactFirstName">
                            </asp:Label></td>
                        <td>
                            <asp:TextBox ID="TxtContactFirstName" runat="server" 
                                TabIndex="2" MaxLength="100" 
                                Width="400px" >
                            </asp:TextBox>
                            <asp:RequiredFieldValidator ID = "ValFirstName" runat = "server" 
                                ControlToValidate = "TxtContactFirstName" 
                                Display = "Dynamic"  
                                ErrorMessage="First Name is Required"  
                                TabIndex="3" 
                                SetFocusOnError="true"
                                ValidationGroup="ReferralContactSave">
                            </asp:RequiredFieldValidator>
                         </td>
                    </tr>
                    <tr style = "height:18px;">
                        <td class="style3">
                            <asp:Label SkinID="DataLabel" runat="server" ID="LabelContactLastName" 
                                Text="Person Contacted Last Name * :" 
                                AssociatedControlID="TxtContactLastName">
                            </asp:Label></td>
                        <td>
                            <asp:TextBox ID="TxtContactLastName" runat="server" 
                                Width="400px"  MaxLength="100"
                                TabIndex="4"> 
                            </asp:TextBox>
                            <asp:RequiredFieldValidator ID="ValLastName" runat="server" 
                                ControlToValidate="TxtContactLastName" 
                                Display="Dynamic" 
                                ErrorMessage="Last Name is Required" 
                                TabIndex="5" 
                                ValidationGroup="ReferralContactSave"
                                SetFocusOnError="true">
                            </asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr style = "height:18px;">
                        <td class="style3">
                            <asp:Label SkinID="DataLabel" runat="server" ID="LabelContactDateTime" 
                                Text="Date Contact was Made (mm/dd/yyyy) * :" 
                                AssociatedControlID="ContactDate:TextBoxDate">
                            </asp:Label>
                        </td>
                        <td>
                            <UserControlFromToDate:FromToDate ID="ContactDate" runat="server" 
                                ToDate="true" 
                                Required="true"  
                                RequiredFieldValidatorErrorMessage="Date Contact was made is required"
                                StartTabIndex="10" 
                                ValidationGroup="ReferralContactSave" 
                                RequiredValidatorValidationGroup="ReferralContactSave"  
                                ErrorMessage="Invalid Date"/>
                         </td>
                     </tr>
                     <tr style = "height:18px;">
                        <td class="style3">   
                            <asp:Label SkinID="DataLabel" ID="LabelContactTime" runat="server" 
                                Text="Time (hh:mm):" 
                                AssociatedControlID="TxtContactTime">
                            </asp:Label>
                            
                        </td>
                        <td>
                            <asp:TextBox ID="TxtContactTime" runat="server" 
                                TabIndex="20"
                                Width = "50px">
                            </asp:TextBox>
                            &nbsp;
                            <asp:DropDownList ID="DdlTimes" runat="server" 
                                TabIndex="21"
                                Width="50px">
                            </asp:DropDownList>
                            &nbsp;
                            <asp:RegularExpressionValidator ID="ContactTimeValidator" runat="server" 
                                TabIndex="22"
                                SetFocusOnError="true" 
                                ValidationExpression="^(?:0?[0-9]|1[0-2])(:[0-5][0-9])?$" 
                                Display="Dynamic" 
                                ControlToValidate="TxtContactTime" 
                                ValidationGroup="ReferralContactSave" 
                                ErrorMessage="Invalid Time Entered.">
                            </asp:RegularExpressionValidator>                      
                         </td>
                    </tr>
                    <tr style = "height:18px;">
                        <td class="style3">
                            <asp:Label SkinID="DataLabel" runat="server" ID="labelContactInitiator" Text="Name of Person Initiating Contact:" AssociatedControlID="lblContactInitiator" Width="300px"></asp:Label>
                        </td>
                        <td>                  
                            <asp:Label SkinID="DataLabel" ID = "lblContactInitiator" runat = "server" Width = "115px"></asp:Label> 
                        
                        </td>
                    </tr>
                    <tr style = "height:20px;">
                        <td class="style3">
                            <asp:Label SkinID="DataLabel" runat="server" ID="labelContactMethod" Text="Method of Contact:" AssociatedControlID="ddlContactMethod"></asp:Label></td>
                        <td style="margin-left: 40px">
                            <asp:DropDownList ID = "ddlContactMethod" runat = "server" 
                                TabIndex="23"
                                Width = "115px">
                            </asp:DropDownList> 
                        </td>
                    </tr>
                    <tr style = "height:20px;">
                        <td class="style3">
                            <asp:Label SkinID="DataLabel" runat="server" ID="labelContactPhone" 
                                Text="Person Contacted Telephone Number:" 
                                AssociatedControlID="txtContactPhone">
                            </asp:Label>
                        </td>
                        <td style="margin-left: 40px">
                            <asp:TextBox ID="txtContactPhone" runat="server" 
                                TabIndex="24"
                                width="400px" 
                                MaxLength="50">
                            </asp:TextBox>
                            <br />
                            <asp:RegularExpressionValidator ID = "RegularExpressionValidator1" runat = "server" 
                                ControlToValidate = "txtContactPhone"
                                ErrorMessage = "Phone field can only contain numbers and the following characters: + - ( ) x" 
                                Display="Dynamic"
                                EnableClientScript="true"
                                SetFocusOnError="true"
                                ValidationExpression = "^(\(?\+?[0-9]*\)?)?[x0-9_\.\- \(\)]*(x)*[0-9_\.\- \(\)]+$" 
                                ValidationGroup = "ReferralContactSave">
                            </asp:RegularExpressionValidator>
                        </td>
                    </tr>
                    <tr style = "height:20px;">
                        <td class="style3">
                            <asp:Label SkinID="DataLabel" runat="server" ID="labelContactEMailAddr" Text="Person Contacted Email:" AssociatedControlID="txtContactEMailAddr" ></asp:Label></td>
                        <td>
                            <asp:TextBox ID="txtContactEMailAddr" runat="server" 
                                TabIndex="25"
                                width="400px" 
                                MaxLength="100">
                            </asp:TextBox>
                            <asp:RegularExpressionValidator ID = "valEMail" runat = "server" 
                                TabIndex="26"
                                ControlToValidate = "txtContactEMailAddr"
                                ErrorMessage = "* Invalid e-mail" 
                                EnableClientScript = "true"
                                SetFocusOnError = "true" 
                                Display = "Dynamic" 
                                ValidationExpression = "^\s*\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*\s*$" 
                                ValidationGroup = "ReferralContactSave">
                            </asp:RegularExpressionValidator>
                        </td>
                    </tr>
                    <tr style = "height:20px;">
                        <td class="style3" >
                            <asp:Label SkinID="DataLabel" runat="server" ID="labelContactAddr1" Text="Person Contacted Address 1:" AssociatedControlID="txtContactAddr1"></asp:Label></td>
                        <td style="margin-left: 40px">
                            <asp:TextBox ID="txtContactAddr1" runat="server" 
                                TabIndex="27"
                                width="400px" 
                                MaxLength="100">
                            </asp:TextBox>
                        </td>
                    </tr>
                    <tr style = "height:20px;">
                        <td class="style3" >
                            <asp:Label SkinID="DataLabel" runat="server" ID="labelContactAddr2" Text="Person Contacted Address 2:" AssociatedControlID="txtContactAddr2"></asp:Label></td>
                        <td style="margin-left: 40px">
                            <asp:TextBox ID="txtContactAddr2" runat="server" 
                                TabIndex="28"
                                width="400px" 
                                MaxLength="100">
                            </asp:TextBox>
                        </td>
                    </tr>
                    <tr style = "height:20px;">
                        <td class="style3" >
                            <asp:Label SkinID="DataLabel" runat="server" ID="labelContactAddr3" Text="Person Contacted Address 3:" AssociatedControlID="txtContactAddr3"></asp:Label></td>
                        <td style="margin-left: 40px">
                            <asp:TextBox ID="txtContactAddr3" runat="server" 
                                TabIndex="29"
                                width="400px" 
                                MaxLength="100">
                            </asp:TextBox>
                        </td>
                    </tr>
                    <tr style = "height:20px;">
                        <td class="style3" >
                            <asp:Label SkinID="DataLabel" runat="server" ID="labelContactCity" Text="Person Contacted City:" AssociatedControlID="txtContactCity"></asp:Label></td>
                        <td style="margin-left: 40px">
                            <asp:TextBox ID="txtContactCity" runat="server" 
                                TabIndex="30"
                                width="400px" 
                                MaxLength="60">
                            </asp:TextBox>
                        </td>
                    </tr>
                    <tr style = "height:20px;">
                        <td class="style3" >
                            <asp:Label SkinID="DataLabel" runat="server" ID="labelContactState" Text="Person Contacted State:" AssociatedControlID="txtContactState"></asp:Label></td>
                        <td style="margin-left: 40px">
                            <asp:TextBox ID="txtContactState" runat="server" 
                                TabIndex="31"
                                width="400px" 
                                MaxLength="60">
                            </asp:TextBox>
                        </td>
                    </tr>
                    <tr style = "height:20px;">
                    <td class="style3" >
                        <asp:Label SkinID="DataLabel" runat="server" ID="labelContactZip" Text="Person Contacted Zip Code&nbsp;" AssociatedControlID="txtContactZip"></asp:Label>
                        <asp:Label SkinID="DataLabel" runat="server" ID="labelContactPlus4" Text="+&nbsp;4" AssociatedControlID="txtContactPlus4"></asp:Label>    
                    </td>
                        
                    <td style="margin-left: 40px">
                        <asp:TextBox ID="txtContactZip" runat="server" 
                            TabIndex="32"
                            width="110px" 
                            MaxLength="50">
                        </asp:TextBox>&nbsp;-&nbsp;
                        <asp:TextBox ID = "txtContactPlus4" runat = "server" 
                            TabIndex="33" MaxLength="6"
                            Width = "40px">
                        </asp:TextBox>
                    </td>
                    </tr>
                    <tr style = "height:20px;">
                        <td class="style3" >
                            <asp:Label SkinID="DataLabel" runat="server" ID="label1" Text="Person Contacted Country:" AssociatedControlID="txtContactCountry"></asp:Label></td>
                        <td style="margin-left: 40px">
                            <asp:TextBox ID="txtContactCountry" runat="server" 
                                TabIndex="34"
                                width="400px" 
                                MaxLength="50">
                            </asp:TextBox>
                        </td>
                    </tr>
                    <tr style = "height:20px;">
                        <td class="style3" >
                            <asp:Label SkinID="DataLabel" ID="LabelContactReason" runat="server" 
                                Text= "Reason for Contact * :" 
                                AssociatedControlID="TxtContactReason">
                            </asp:Label></td>
                        <td style="margin-left: 40px">
                            <asp:TextBox ID="TxtContactReason" runat="server" 
                                TabIndex="35" MaxLength="4000"
                                width="400px">
                            </asp:TextBox>
                            <asp:RequiredFieldValidator ID = "ValContactReason" runat = "server" 
                                TabIndex="36"
                                SetFocusOnError="true" 
                                ControlToValidate = "TxtContactReason" 
                                Display = "Dynamic" 
                                ErrorMessage="Reason is Required" 
                                ValidationGroup="ReferralContactSave">
                            </asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr style = "height:20px;">
                        <td class="style3" >
                            <asp:Label SkinID="DataLabel" ID="LabelContactText" runat="server" 
                                Text= "Textual Record of the Contact Conversation * :" 
                                AssociatedControlID="TxtContactText">
                            </asp:Label></td>
                        <td style="margin-left: 40px">
                            <asp:TextBox ID="TxtContactText" runat="server" 
                                TabIndex="37"
                                width="400px"  
                                TextMode="MultiLine"  
                                onKeyUp="MultiLineTextBoxMaxLength(this,4000)" 
                                onChange="MultiLineTextBoxMaxLength(this,4000)" 
                                Height="130px" >
                            </asp:TextBox>
                            <asp:RequiredFieldValidator ID="ValContactText" runat="server" 
                                TabIndex="38"
                                SetFocusOnError="true" 
                                ControlToValidate="TxtContactText" 
                                Display="Dynamic" 
                                ErrorMessage="Textual Record of the Contact Conversation is required" 
                                ValidationGroup="ReferralContactSave">
                            </asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr style = "height:20px;">
                        <td class="style3" valign = "top">
                        </td>
                        <td style="margin-left: 40px" valign = "top" align = "left" >                        
                        <asp:Panel ID = "rbProviderConsultationPanel" runat = "server" GroupingText = "Telemedicine Consultation with Provider?:">    
                            <asp:RadioButtonList ID = "rbProviderConsultation" runat = "server"
                                TabIndex="39"
                                RepeatDirection = "Horizontal">
                                <asp:ListItem Value="1" Text = "Yes"></asp:ListItem>
                                <asp:ListItem Value ="0" Selected= "True" Text = "No"></asp:ListItem>   
                            </asp:RadioButtonList>
                            
                        </asp:Panel>     
                        </td>
                    </tr>
                    <tr style = "height:20px;">
                        <td class="style3" >
                            &nbsp;
                        </td>
                        <td style="margin-left: 40px" valign = "top" align = "left" >
                        <asp:Panel ID = "rbPatientConsultationPanel" runat = "server" GroupingText = "Telemedicine Consultation with Patient?:">
                            <asp:RadioButtonList ID = "rbPatientConsultation" runat = "server"
                                TabIndex="40"
                                RepeatDirection = "Horizontal">
                                <asp:ListItem Value="1">Yes</asp:ListItem>
                                <asp:ListItem Value ="0" Selected= "True">No</asp:ListItem>   
                            </asp:RadioButtonList> 
                        </asp:Panel> 
                        </td>
                    </tr>
                    <tr style = "height:20px;">
                    <td class="style3" >
                        &nbsp;
                    </td>
                    <td style="margin-left: 40px" valign = "top" align = "left" > 
                        <asp:Panel ID = "rbInpatientEvalPanel" runat = "server" GroupingText = "Inpatient Evaluation Recommended?:">
                            <asp:RadioButtonList ID = "rbInpatientEval" runat = "server" 
                                TabIndex="41"
                                RepeatDirection = "Horizontal">
                                <asp:ListItem Value="1">Yes</asp:ListItem>
                                <asp:ListItem Value ="0" Selected= "True">No</asp:ListItem>   
                            </asp:RadioButtonList> 
                        </asp:Panel> 
                    </td>
                    </tr>
                    <tr style = "height:20px;" class = "evalClass">
                        <td class="style3">
                            <asp:Label SkinID="DataLabel" runat="server" ID="LabelInpatientEvalDate" 
                                Visible="true"
                                Text="Inpatient Evaluation Completed Date (mm/dd/yyyy):" 
                                AssociatedControlID="InpatientEvalDate:TextBoxDate">
                            </asp:Label>
                        </td>
                        <td>
                            <UserControlFromToDate:FromToDate ID="InpatientEvalDate" runat="server" 
                                ToDate="true" 
                                StartTabIndex="45" 
                                ValidationGroup="ReferralContactSave" 
                                ErrorMessage="Invalid Date"/>
                        </td>
                    </tr>
                    <tr style = "height:20px;">
                        <td class="style3" >
                                &nbsp;
                        </td>
                        <td style="margin-left: 40px" valign = "top" align = "left" >
                         <asp:Panel ID = "rbFollowupPanel" runat = "server" GroupingText = "Follow Up Contact Needed?:">   
                            <asp:RadioButtonList ID = "rbFollowup" runat = "server"
                                TabIndex="50" 
                                RepeatDirection = "Horizontal">
                                <asp:ListItem Value="1" Text = "Yes"></asp:ListItem>
                                <asp:ListItem Value ="0" Selected= "True" Text = "No"></asp:ListItem>   
                            </asp:RadioButtonList>
                         </asp:Panel> 
                        </td>
                    </tr>
                    <tr style = "height:20px;" class = "followupClass">
                        <td class="style3">
                            <asp:Label SkinID="DataLabel" runat="server" ID="labelFollowupRequiredDate" 
                                Text="Follow Up Contact Required By Date (mm/dd/yyyy):" 
                                AssociatedControlID="FollowupRequiredDate">
                            </asp:Label></td>
                        <td>
                             <asp:TextBox ID = "FollowupRequiredDate" runat = "server" Width = "100px"></asp:TextBox>
                              <asp:CompareValidator ID = "FollowupRequiredDateValidator" runat = "server"                                    
                                    ControlToValidate = "FollowupRequiredDate"                                     
                                    SetFocusOnError = "true" 
                                    ValidationGroup = "ReferralContactSave" 
                                    EnableClientScript = "true" 
                                    Operator = "GreaterThan"                                       
                                    ErrorMessage = "Follow Up Contact Date has to be in format(mm/dd/yyyy) and has to be a future date." 
                                    Display = "Dynamic"
                                    Type= "Date"/>  
                             <asp:RequiredFieldValidator ID = "FollowUpContactDateRequiredValidator" runat = "server" 
                                    Display = "Dynamic" 
                                    ErrorMessage = "Follow Up Contact Date is required."
                                    ValidationGroup = "ReferralContactSave" EnableClientScript="true"
                                    SetFocusOnError="true" ControlToValidate = "FollowupRequiredDate" >
                             </asp:RequiredFieldValidator>    
                             
                        </td>
                    </tr>
                    <tr style = "height:20px;" class = "followupClass">
                        <td class="style3">
                            <asp:Label SkinID="DataLabel" runat="server" ID="labelRemindDate" 
                                Text="Remind Me On (mm/dd/yyyy):" 
                                AssociatedControlID="ReminderDate">
                            </asp:Label></td>
                        <td>
                             <asp:TextBox ID = "ReminderDate" runat = "server" Width = "100px"></asp:TextBox>
                             <asp:CompareValidator ID = "ReminderDateCompareValidator" runat = "server"                                    
                                    ControlToValidate = "ReminderDate"
                                    ControlToCompare = "FollowupRequiredDate"                                     
                                    SetFocusOnError = "true" 
                                    EnableClientScript = "true" 
                                    Operator = "LessThanEqual"  
                                    ValidationGroup = "InterpretSaveComplete"                                       
                                    ErrorMessage = "Reminder Date has to be in format(mm/dd/yyyy) and no later than Follow Up Contact Date." 
                                    Display = "Dynamic"
                                    Type= "Date" />
                                 
                             <asp:CompareValidator ID = "ReminderDateValidator" runat = "server"                                    
                                    ControlToValidate = "ReminderDate"                                     
                                    SetFocusOnError = "true" 
                                    ValidationGroup = "ReferralContactSave" 
                                    EnableClientScript = "true" 
                                    Operator = "GreaterThanEqual"                                        
                                    ErrorMessage = "Reminder Date has to be in format(mm/dd/yyyy) and cannot be a past date." 
                                    Display = "Dynamic"
                                    Type= "Date"/>  
                               
                        </td>
                    </tr>
                    <tr style = "height:20px;" class = "followupClass">
                        <td class="style3">
                            <asp:Label SkinID="DataLabel" runat="server" ID="LabelFollowupCompletedDate" 
                                Text="Follow Up Contact Completed Date (mm/dd/yyyy):" 
                                AssociatedControlID="FollowupCompletedDate:TextBoxDate">
                            </asp:Label></td>
                        <td>
                             <UserControlFromToDate:FromToDate ID="FollowupCompletedDate" runat="server" 
                                ToDate="true" 
                                StartTabIndex="60" 
                                ValidationGroup="ReferralContactSave" 
                                ErrorMessage="Invalid Date"/>                            
                               
                        </td>
                    </tr>
                </table>
            </asp:Panel>  
            </td> 
        </tr>
        <tr align = "center">
            <td>
             <br />

             <asp:Button ID = "SaveButton" runat = "server" 
                TabIndex="65" 
                Text = "Save" Width = "130px" OnClick = "SaveButton_Click" ValidationGroup = "ReferralContactSave" />        
             
             <asp:Button ID = "CancelButton" runat = "server" 
                TabIndex="66" 
                Text = "Cancel" Width = "130px" OnClick="CancelButton_OnClick" UseSubmitBehavior = "false" CssClass = "cancel"/>
            </td>            
        </tr>
    </table>  
</asp:Content>
